<?php
session_start();
include('includes/dbconn.php');

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $fullName = $_POST['fullname'];
    $username = $_POST['username'];
    $email = $_POST['email'];
    $password = $_POST['password'];
    $companyName = $_POST['name'];
    $companyAddress = $_POST['address'];
    $companyIndustry = $_POST['industry'];

    $conn->begin_transaction();
    try {
        $sqlCompany = "INSERT INTO companies (name, industry, address) VALUES (?, ?, ?)";
        $stmtCompany = $conn->prepare($sqlCompany);
        if (!$stmtCompany) {
            throw new Exception("Prepare failed: " . $conn->error);
        }
        $stmtCompany->bind_param("sss", $companyName, $companyIndustry, $companyAddress);
        if (!$stmtCompany->execute()) {
            throw new Exception("Execute failed: " . $stmtCompany->error);
        }
        $companyId = $conn->insert_id;

        $passwordHash = password_hash($password, PASSWORD_DEFAULT);
        $sqlUser = "INSERT INTO users (company_id, username, email, password_hash, full_name) VALUES (?, ?, ?, ?, ?)";
        $stmtUser = $conn->prepare($sqlUser);
        if (!$stmtUser) {
            throw new Exception("Prepare failed: " . $conn->error);
        }
        $stmtUser->bind_param("issss", $companyId, $username, $email, $passwordHash, $fullName);
        if (!$stmtUser->execute()) {
            throw new Exception("Execute failed: " . $stmtUser->error);
        }

        $conn->commit();
        echo "Registration successful. Company ID: " . $companyId;
    } catch (Exception $e) {
        $conn->rollback();
        echo "Error: " . $e->getMessage();
    }

    $stmtCompany->close();
    $stmtUser->close();
    $conn->close();
}
?>
